/*
 * Decompiled with CFR 0.152.
 */
package moe.ytonidc.dimensional_stomach;

import java.util.List;
import moe.ytonidc.dimensional_stomach.StomachCapability;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class StomachUpgradeItem
extends Item {
    private final int requiredLevel;
    private final int targetLevel;

    public StomachUpgradeItem(Item.Properties properties, int requiredLevel) {
        super(properties);
        this.requiredLevel = requiredLevel;
        this.targetLevel = requiredLevel + 1;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            player.getCapability(StomachCapability.STOMACH_CAPABILITY).ifPresent(manager -> {
                int currentLevel = manager.getStomachLevel();
                if (currentLevel != this.requiredLevel) {
                    player.m_5661_((Component)Component.m_237110_((String)"message.dimensional_stomach.upgrade_require_level", (Object[])new Object[]{this.requiredLevel, currentLevel}).m_130940_(ChatFormatting.RED), true);
                    return;
                }
                if (manager.upgradeStomach()) {
                    int newSlots = manager.getUnlockedSlots();
                    player.m_5661_((Component)Component.m_237110_((String)"message.dimensional_stomach.upgrade_success", (Object[])new Object[]{this.requiredLevel, this.targetLevel, newSlots}).m_130940_(ChatFormatting.GREEN), true);
                    manager.applyAttributes(player);
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                }
            });
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.dimensional_stomach.upgrade_usage").m_130940_(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.dimensional_stomach.upgrade_level", (Object[])new Object[]{this.requiredLevel, this.targetLevel}).m_130940_(ChatFormatting.AQUA));
        tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.dimensional_stomach.upgrade_slots", (Object[])new Object[]{this.requiredLevel * 9, this.targetLevel * 9}).m_130940_(ChatFormatting.YELLOW));
        tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.dimensional_stomach.upgrade_require", (Object[])new Object[]{this.requiredLevel}).m_130940_(ChatFormatting.GOLD));
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.dimensional_stomach.consumable").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC}));
    }

    public boolean m_5812_(ItemStack stack) {
        return this.targetLevel >= 3;
    }

    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    public int getTargetLevel() {
        return this.targetLevel;
    }
}

